unit CopyFile_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    btnCopyFile: TButton;
    procedure btnCopyFileClick(Sender: TObject);
  private
    { Private declarations }
    procedure copyMyFile(fromFile: String; toFile: String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.btnCopyFileClick(Sender: TObject);
var
  fromFile: String;
  toFile: String;
begin
  fromFile := InputBox('File Copy', 'Copy from - filename:', '');
  toFile := InputBox('File Copy', 'Copy to - filename:', '');
  copyMyFile(fromFile, toFile);
end;

procedure TForm1.copyMyFile(fromFile, toFile: String);
var
  infile: TextFile;
  outFile: TextFile;
  line: String;
begin
  if Not FileExists(fromFile) then
    showMessage(fromFile + ' NOT FOUND')
  else
  begin
    AssignFile(infile, fromFile);
    Reset(infile);
    AssignFile(outFile, toFile);
    Rewrite(outFile);
    while not eof(infile) do
    begin
      readln(infile, line);
      writeln(outFile, line);
    end;
    closeFile(infile);
    closeFile(outFile);
    showMessage('File copied');

  end;
end;

end.
